/*!
 * @file        usbd_descriptor.h
 *
 * @brief       USB descriptor
 *
 * @version     V1.0.1
 *
 * @date        2022-05-25
 *
 * @attention
 *
 *  Copyright (C) 2021-2022 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be usefull and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */
#ifndef USBD_DESCRIPTOR_H_
#define USBD_DESCRIPTOR_H_

#include "usbd_core.h"

#define UID_ADDRESS1           0x1FFF7A10
#define UID_ADDRESS2           0x1FFF7A14
#define UID_ADDRESS3           0x1FFF7A18

#define USB_DEVICE_DESCRIPTOR_SIZE          (18)
#define USB_CONFIG_DESCRIPTOR_SIZE          (32)
#define USB_LANGID_STRING_SIZE              (4)
#define USB_VENDOR_STRING_SIZE              (12)
#define USB_PRODUCT_STRING_SIZE             (26)
#define USB_SERIAL_STRING_SIZE              (26)
#define USB_USER_STRING_1_SIZE              (94)
#define USB_USER_STRING_2_SIZE              (72)
#define USB_QUALIFIER_DESCRIPTOR_SIZE       (10)

#define USBD_NumberToChar(num)    (((num) < 0xA) ? ((num) + '0') : ((num) - 10 + 'A'))

extern uint8_t g_usbDeviceDescriptor[USB_DEVICE_DESCRIPTOR_SIZE];
extern uint8_t g_usbConfigDescriptor[USB_CONFIG_DESCRIPTOR_SIZE];
extern uint8_t g_usbLandIDString[USB_LANGID_STRING_SIZE];
extern uint8_t g_usbVendorString[USB_VENDOR_STRING_SIZE];
extern uint8_t g_usbProductString[USB_PRODUCT_STRING_SIZE];
extern uint8_t g_usbSerialString[USB_SERIAL_STRING_SIZE];
extern uint8_t g_usbQualifierDescriptor[USB_QUALIFIER_DESCRIPTOR_SIZE];

extern USBD_Descriptor_T g_deviceDescriptor;
extern USBD_Descriptor_T g_configDescriptor;
extern USBD_Descriptor_T g_stringDescriptor[];
extern USBD_Descriptor_T g_qualifierDescriptor;

void USBD_ConfigSerialString(uint8_t *string);

#endif

